% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpts.R
\name{summary.vpts}
\alias{summary.vpts}
\alias{is.vpts}
\alias{dim.vpts}
\title{Class \code{vpts}: a time series of vertical profiles}
\usage{
\method{summary}{vpts}(object, ...)

is.vpts(x)

\method{dim}{vpts}(x)
}
\arguments{
\item{object}{An object of class \code{vpts}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{An object of class \code{vpts}.}
}
\value{
For \code{is.vpts}: \code{TRUE} if its argument is of
class \code{vpts}.

For \code{dim.vpts}: dimensions of the time series.
}
\description{
Class \code{vpts} for a time series of vertical profiles, and its associated
R base functions.
}
\details{
An object of class \code{vpts} contains time-ordered profiles of a single
radar station.

The time series can be regular or irregular, indicated by the \code{regular}
field

In a regular \code{vpts} object the profiles are equally spaced in time. In
an irregular \code{vpts} object the time steps between profiles are of
unequal length.

Irregular time series can be projected onto a regular time grid using
the \link{regularize_vpts} function.

By contrast, \link[=summary.vp]{vp} objects can be concatenated in a list
to combine profiles without time ordering, and profiles of
multiple radars.

Data contained in this class object should be accessed with the
\link{get_quantity} function. Information stored under \code{attributes}
(see below) can be accessed directly.

An object of class \code{vpts} is a list containing
\describe{
 \item{\code{radar}}{string containing the radar identifier}
 \item{\code{datetime}}{the \code{N} nominal times of the profiles (named \code{dates} in bioRad versions < 0.4.0)}
 \item{\code{height}}{the \code{M} heights of the layers in the profile}
 \item{\code{daterange}}{the minimum and maximum nominal time of the
   profiles in the list}
 \item{\code{timesteps}}{time differences between the profiles. Element
   \code{i} gives the time difference between profile \code{i} and
   \code{i+1}}
 \item{\code{data}}{list of \code{N} by \code{M} matrices containing the
   vertical profiles for each quantity. For a description of available
   quantities, see the \code{data} element of the \code{vp} class in
   \link[=summary.vp]{read_vpfiles}}
 \item{\code{attributes}}{profile attributes, copied from the first profile
   contained in \code{x}}
 \item{\code{regular}}{logical indicating whether the time series is
   regular or not}
}
}
\examples{
# load example vertical profile time series:
data(example_vpts)
example_vpts

# verify this is a vpts object
is.vpts(example_vpts)

# dimensions of the vpts object
dim(example_vpts)
}
