% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgtp.R
\name{rgtp}
\alias{rgtp}
\title{Simulation of generalized Thomas process}
\usage{
rgtp(
  kappa,
  omega,
  lambda,
  theta,
  win = owin(c(0, 1), c(0, 1)),
  nsim = 1,
  expand = 4 * omega,
  C = NULL
)
}
\arguments{
\item{kappa}{intensity of cluster centers.}

\item{omega}{standard deviation of normal distribution specifying the clusters spread.}

\item{lambda}{parameter of generalised Poisson distribution controlling over or under dispersion.}

\item{theta}{parameter of generalised Poisson distribution controlling the mean number of points in a cluster.}

\item{win}{window in which to simulate the pattern. An object in the \cr \code{\link[spatstat.geom:owin]{spatstat.geom::owin()}} format of the \pkg{spatstat} package.}

\item{nsim}{number of simulations.}

\item{expand}{the size of expansion of window to simulate the centers of clusters.}

\item{C}{process of center points.}
}
\value{
A list(X, C), where \emph{X} is Generalized Thomas process, and \emph{C} is Process of cluster centers for Generalized Thomas process.
}
\description{
Simulation of generalized Thomas process.
}
\examples{

library(spatstat)
kappa = 10
omega = .1
lambda= .5
theta = 10

X = rgtp(kappa, omega, lambda, theta, win = owin(c(0, 1), c(0, 1)))
plot(X$X)
plot(X$C)

}
