% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboarder-shiny.R
\name{bb_proxy_data_names}
\alias{bb_proxy_data_names}
\title{Change names of the data with proxy}
\usage{
bb_proxy_data_names(proxy, old = NULL, new = NULL)
}
\arguments{
\item{proxy}{A \code{billboardProxy} \code{htmlwidget} object.}

\item{old}{Old names}

\item{new}{New names}
}
\value{
A \code{billboardProxy} \code{htmlwidget} object.
}
\description{
Change names of the data with proxy
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(billboarder)

ui <- fluidPage(
  tags$h2("Update axis title & data name (tooltip & legend)"),
  billboarderOutput(outputId = "my_bb"),
  textInput(
    inputId = "new_name",
    label = "New name :",
    value = "this is a new name",
    width = "100\%"
  ),
  actionButton(
    inputId = "update",
    label = "Update chart",
    width = "100\%"
  )
)

server <- function(input, output, session) {
  
  output$my_bb <- renderBillboarder({
    dat <- sample(letters[1:5], 100, TRUE)
    billboarder() \%>\%
      bb_barchart(data = table(dat)) \%>\% 
      bb_y_axis(label = list(text = "Freq"))
  })
  
  observeEvent(input$update, {
    dat <- sample(letters[1:5], 100, TRUE)
    billboarderProxy(shinyId = "my_bb") \%>\% 
      bb_proxy_axis_labels(y = input$new_name) \%>\% 
      bb_proxy_data_names(old = "Freq", 
                          new = input$new_name) \%>\% 
      bb_barchart(data = table(dat))
  }, ignoreInit = TRUE)
  
}

shinyApp(ui, server)

}

}
}
