% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_barchart}
\alias{bb_barchart}
\title{Helper for creating a bar chart}
\usage{
bb_barchart(bb, data, stacked = FALSE, rotated = FALSE, color = NULL, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}, the first column will be used for x axis unless
specified otherwise in \code{...}. If not a \code{data.frame}, an object coercible to \code{data.frame}.}

\item{stacked}{Logical, if several columns provided, produce a stacked bar chart, else
a dodge bar chart.}

\item{rotated}{Switch x and y axis position.}

\item{color}{Bar's color.}

\item{...}{Arguments for slot bar, see \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.bar}.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a bar chart
}
\note{
This function can be used with \code{\link{billboarderProxy}} in shiny application.
}
\examples{
library("billboarder")

stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer", "shinyWidgets", "visNetwork"),
  stars = c(1, 176, 42, 40, 166)
)

billboarder() \%>\%
  bb_barchart(data = stars)

billboarder() \%>\%
  bb_barchart(data = stars, labels = TRUE) \%>\%
  bb_data(names = list(stars = "Number of stars")) \%>\% 
  bb_axis(rotated = TRUE)
}
