% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagmatrix.R
\name{lagmatrix}
\alias{lagmatrix}
\title{Creates Lagmatrix of Estimated Coefficients}
\usage{
lagmatrix(fit, model, returnplot = F)
}
\arguments{
\item{fit}{Fitted VAR, VARX or VARMA model.}

\item{model}{Type of model that was estimated: VAR, VARX or VARMA.}

\item{returnplot}{TRUE or FALSE: return plot of lag matrix or not.}
}
\value{
A list with estimated lag matrix of the VAR model, or lag matrices of the VARX or VARMA model. The rows contain the responses, the columns contain the predictors.
}
\description{
Creates Lagmatrix of Estimated Coefficients
}
\examples{
data(Y)
data(X)
VARXfit <- sparseVARX(Y=Y, X=X) # sparse VARX
Lhats <- lagmatrix(fit=VARXfit, model="VARX")
}
