% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{asPlotlyText}
\alias{asPlotlyText}
\title{Plotly text}
\usage{
asPlotlyText(df)
}
\arguments{
\item{df}{A data.frame}
}
\value{
A character vector of the length of \code{df}'s number of rows.
}
\description{
Convert a data.frame to plotly text
}
\examples{
set.seed(1)

X <- big_attachExtdata()
svd <- big_SVD(X, big_scale(), k = 10)

p <- plot(svd, type = "scores")

pop <- rep(c("POP1", "POP2", "POP3"), c(143, 167, 207))
df <- data.frame(Population = pop, Index = 1:517)

plot(p2 <- p + ggplot2::aes(text = asPlotlyText(df)))
\dontrun{plotly::ggplotly(p2, tooltip = "text")}
}
