% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed-clumping.R, R/clumping.R
\name{bed_clumping}
\alias{bed_clumping}
\alias{snp_clumping}
\alias{snp_pruning}
\alias{snp_indLRLDR}
\title{LD clumping}
\usage{
bed_clumping(
  obj.bed,
  ind.row = rows_along(obj.bed),
  S = NULL,
  thr.r2 = 0.2,
  size = 100/thr.r2,
  exclude = NULL,
  ncores = 1
)

snp_clumping(
  G,
  infos.chr,
  ind.row = rows_along(G),
  S = NULL,
  thr.r2 = 0.2,
  size = 100/thr.r2,
  infos.pos = NULL,
  is.size.in.bp = NULL,
  exclude = NULL,
  ncores = 1
)

snp_pruning(
  G,
  infos.chr,
  ind.row = rows_along(G),
  size = 49,
  is.size.in.bp = FALSE,
  infos.pos = NULL,
  thr.r2 = 0.2,
  exclude = NULL,
  nploidy = 2,
  ncores = 1
)

snp_indLRLDR(infos.chr, infos.pos, LD.regions = LD.wiki34)
}
\arguments{
\item{obj.bed}{Object of type \code{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{S}{A vector of column statistics which express the importance
of each SNP (the more important is the SNP, the greater should be
the corresponding statistic).\cr
For example, if \code{S} follows the standard normal distribution, and "important"
means significantly different from 0, you must use \code{abs(S)} instead.\cr
\strong{If not specified, MAFs are computed and used.}}

\item{thr.r2}{Threshold over the squared correlation between two SNPs.
Default is \code{0.2}.}

\item{size}{For one SNP, window size around this SNP to compute correlations.
Default is \code{100 / thr.r2} for clumping (0.2 -> 500; 0.1 -> 1000; 0.5 -> 200).
If not providing \code{infos.pos} (\code{NULL}, the default), this is a window in
number of SNPs, otherwise it is a window in kb (genetic distance).
I recommend that you provide the positions if available.}

\item{exclude}{Vector of SNP indices to exclude anyway. For example,
can be used to exclude long-range LD regions (see Price2008). Another use
can be for thresholding with respect to p-values associated with \code{S}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values.} Also, remember to do quality control,
e.g. some algorithms in this package won't work if you use SNPs with 0 MAF.}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \verb{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{is.size.in.bp}{Deprecated.}

\item{nploidy}{Number of trials, parameter of the binomial distribution.
Default is \code{2}, which corresponds to diploidy, such as for the human genome.}

\item{LD.regions}{A \code{data.frame} with columns "Chr", "Start" and "Stop".
Default use the table of 34 long-range LD regions that you can find
\href{https://goo.gl/0Ou7uI}{there}.}
}
\value{
\itemize{
\item \code{snp_clumping()} (and \code{bed_clumping()}): SNP indices that are \strong{kept}.
\item \code{snp_indLRLDR()}: SNP indices to be used as (part of) the '\strong{\code{exclude}}'
parameter of \code{snp_clumping()}.
}
}
\description{
For a \code{bigSNP}:
\itemize{
\item \code{snp_pruning()}: LD pruning. Similar to "\verb{--indep-pairwise (size+1) 1 thr.r2}"
in \href{https://www.cog-genomics.org/plink/1.9/ld}{PLINK}.
\strong{This function is deprecated (see
\href{https://privefl.github.io/bigsnpr/articles/pruning-vs-clumping.html}{this article}).}
\item \code{snp_clumping()} (and \code{bed_clumping()}): LD clumping. If you do not provide
any statistic to rank SNPs, it would use minor allele frequencies (MAFs),
making clumping similar to pruning.
\item \code{snp_indLRLDR()}: Get SNP indices of long-range LD regions for the
human genome.
}
}
\examples{
test <- snp_attachExtdata()
G <- test$genotypes

# clumping (prioritizing higher MAF)
ind.keep <- snp_clumping(G, infos.chr = test$map$chromosome,
                         infos.pos = test$map$physical.pos,
                         thr.r2 = 0.1)

# keep most of them -> not much LD in this simulated dataset
length(ind.keep) / ncol(G)

}
\references{
Price AL, Weale ME, Patterson N, et al.
Long-Range LD Can Confound Genome Scans in Admixed Populations.
Am J Hum Genet. 2008;83(1):132-135. \doi{10.1016/j.ajhg.2008.06.005}
}
