% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{snp_cor}
\alias{snp_cor}
\title{Correlation}
\usage{
snp_cor(Gna, ind.row = rows_along(Gna), ind.col = cols_along(Gna),
  size = 500, alpha = 0.05, fill.diag = TRUE)
}
\arguments{
\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
You can have missing values in your data.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{size}{For one SNP, number of SNPs at its left and its right to
be tested for being correlated with this particular SNP.}

\item{alpha}{Type-I error for testing correlations.}

\item{fill.diag}{Whether to fill the diagonal with 1s (the default)
or to keep it as 0s.}
}
\value{
The correlation matrix. This is a sparse symmetric matrix.
}
\description{
Get significant correlations between nearby SNPs.
}
\details{
P-values are computed by a two-sided t-test.
}
\examples{
test <- snp_attachExtdata()

corr <- snp_cor(test$genotypes, ind.col = 1:1000)
corr[1:10, 1:10]

# Sparsity
length(corr@x) / length(corr)

}
