% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower_interpolation_mds.R
\name{gower_interpolation_mds}
\alias{gower_interpolation_mds}
\title{MDS based on Gower interpolation formula}
\usage{
gower_interpolation_mds(x, l, k)
}
\arguments{
\item{x}{Data matrix.}

\item{l}{The highest value where classical MDS can be computed efficiently.}

\item{k}{Number of principal coordinates.}
}
\value{
Returns MDS based on Fast MDS algorithm as well as the first k eigenvalues.
\describe{
\item{points}{MDS}
\item{eigen}{eigenvalues}
}
}
\description{
Performs Multidimensional Scaling based on Gower interpolation formula.
}
\examples{
x <- matrix(data = rnorm(4*10000, sd = 10), nrow = 10000)
cmds <- gower_interpolation_mds(x = x, l = 100, k = 2)
head(cmds$points)
cmds$eigen
}
\seealso{
\url{https://arxiv.org/abs/2007.11919}
}
