% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_roughness.r
\name{wind.profile}
\alias{wind.profile}
\title{Wind Speed at Given Heights in the Surface Layer}
\usage{
wind.profile(data, heights, Tair = "Tair", pressure = "pressure",
  ustar = "ustar", H = "H", zr, zh, d = NULL, frac_d = 0.7,
  z0m = NULL, frac_z0m = 0.1, stab_correction = TRUE,
  stab_formulation = c("Dyer_1970", "Businger_1971"),
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{heights}{Vector with heights for which wind speed is to be 
calculated.}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{ustar}{Friction velocity (m s-1)}

\item{H}{Sensible heat flux (W m-2)}

\item{zr}{Instrument (reference) height (m)}

\item{zh}{Canopy height (m)}

\item{d}{Zero-plane displacement height (-)}

\item{frac_d}{Fraction of displacement height on canopy height (-);
only used if \code{d} is not available}

\item{z0m}{Roughness length (m), optional; only used if stab_correction=FALSE (default=0.1)}

\item{frac_z0m}{Fraction of roughness length on canopy height (-), optional; only used 
if \code{stab_correction = FALSE} (default=0.1), only used if \code{z0m} is not available}

\item{stab_correction}{Should stability correction be applied? Defaults to \code{TRUE}}

\item{stab_formulation}{Stability correction function used (If \code{stab_correction = TRUE}).
Either \code{"Dyer_1970"} or \code{"Businger_1971"}.}

\item{constants}{k - von-Karman constant (-) \cr
Kelvin - conversion degree Celsius to Kelvin \cr
cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
g - gravitational acceleration (m s-2) \cr}
}
\value{
A data.frame with rows representing time and columns representing heights 
        as specified in \code{heights}.
}
\description{
wind speed at a given height above the canopy estimated from single-level
             measurements of wind speed at some distance above the canopy.
}
\details{
The underlying assumption is the existence of a logarithmic wind profile
         above the height d + z0m (the height at which wind speed mathematically reaches zero
         according to the Monin-Obhukov similarity theory).
         In this case, the wind speed at a given height z is given by:
         
           \deqn{u(z) = (ustar/k) * (ln((z - d) / z0m) - \psi{m}}
         
         The roughness parameters zero-plane displacement height (d) and roughness length (z0m)
         can be approximated from \code{\link{roughness.parameters}}.
}
\note{
Note that this equation is only valid for z >= d + z0m, and it is not 
      meaningful to calculate values closely above d + z0m. All values in \code{heights}
      smaller than d + z0m will return 0.
}
\examples{
df <- data.frame(Tair=25,pressure=100,wind=c(3,4,5),ustar=c(0.5,0.6,0.65),H=c(200,230,250)) 
wind.profile(df,heights=seq(18,40,2),zr=40,zh=25,d=16)

}
\seealso{
\code{\link{roughness.parameters}}
}
