% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_list_sparse_feature_adjmat.R
\name{compute_multiplied_feature_matrices}
\alias{compute_multiplied_feature_matrices}
\title{Get a list of sparse feature adjacency matrix from a formula.}
\usage{
compute_multiplied_feature_matrices(net, list_feature_matrices)
}
\arguments{
\item{net}{a network object from which nodal covariates are extracted.}

\item{list_feature_matrices}{a list of feature adjacency matrices generated by \code{get_list_sparse_feature_adjmat()}.}
}
\value{
A list of sparse matrices of multiplied feature matrices that are needed for carrying our the first step of the estimation if the covariates should be used.
}
\description{
These matrices can be given to the \code{\link{hergm}} function as parameters. Generally, this function should only be used if users are working with large networks and are planning to continually estimate the model.
}
\examples{
data(toyNet)
\donttest{
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") 
list_feature_matrices <- get_list_sparse_feature_adjmat(toyNet, model_formula)
multiplied_feature_matrices <- 
  compute_multiplied_feature_matrices(net = toyNet,
  list_feature_matrices = list_feature_matrices)
}
}
