% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_eco_opening.R
\name{browse_eco_opening}
\alias{browse_eco_opening}
\title{Browse ECO opening}
\usage{
browse_eco_opening(df, topn = 0)
}
\arguments{
\item{df}{data frame with imported chess games from read.pgn() function.}

\item{topn}{integer, default is 0, passed to tree_eco function (indicating how many top openings should be included).}
}
\value{
Data frame from tree_eco function and plot from plot_tree_eco function.
}
\description{
Browse ECO opening winning and drawing percentages by table and barplot
}
\examples{
f <- system.file("extdata", "Kasparov.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,ignore.other.games = TRUE,stat.moves = FALSE, add.tags = "ECO")
# Analyze 20 best ECO Kasparov openings:
bo <- browse_eco_opening(subset(df,grepl("Kasparov",White)),20)
}
