% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{bqr_create_table}
\alias{bqr_create_table}
\title{Create a Table}
\usage{
bqr_create_table(projectId = bqr_get_global_project(),
  datasetId = bqr_get_global_dataset(), tableId, template_data = NULL,
  timePartitioning = FALSE, expirationMs = 0L)
}
\arguments{
\item{projectId}{The BigQuery project ID.}

\item{datasetId}{A datasetId within projectId.}

\item{tableId}{Name of table you want.}

\item{template_data}{A dataframe with the correct types of data. If \code{NULL} an empty table is made.}

\item{timePartitioning}{Whether to create a partioned table}

\item{expirationMs}{If a partioned table, whether to have an expiration time on the data. The default \code{0} is no expiration.}
}
\value{
TRUE if created, FALSE if not.
}
\description{
Create a Table
}
\details{
Creates a BigQuery table.

If setting \code{timePartioning} to \code{TRUE} then the table will be a 
  \href{https://cloud.google.com/bigquery/docs/creating-partitioned-tables}{partioned table}
  
If you want more advanced features for the table, create it then call \link{bqr_patch_table} with advanced configuration configured from \link{Table}
}
\seealso{
Other Table meta functions: \code{\link{Table}},
  \code{\link{bqr_copy_table}},
  \code{\link{bqr_delete_table}},
  \code{\link{bqr_list_tables}},
  \code{\link{bqr_patch_table}},
  \code{\link{bqr_table_data}},
  \code{\link{bqr_table_meta}}
}
\concept{Table meta functions}
