% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib2df.R
\name{bib2df}
\alias{bib2df}
\title{Convert a bibtex file into a data frame}
\usage{
bib2df(D, dbsource = "isi")
}
\arguments{
\item{D}{is a character array containing bibliographic data in bibtex format.}

\item{dbsource}{is a character indicating the bibliographic database. \code{dbsource} can be \code{"isi"}, \code{"scopus"} or \code{generic}. Default is \code{dbsource = "isi"}.}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It is an internal function used by \code{\link{convert2df}} to convert a bibtex file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A ISI Export file can be read using \\code{\\link{readLines}} function:

# largechar <- readFiles('filename1.bib','filename2.bib2,...)

# filename.bib is a bibtex file in plain text format.

# largechar <- readFiles('http://www.bibliometrix.org/datasets/ranking.bib')

# ranking <- bib2df(largechar)

}
\seealso{
\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting functions: \code{\link{cochrane2df}},
  \code{\link{convert2df}}, \code{\link{isi2df}},
  \code{\link{isibib2df}}, \code{\link{pubmed2df}},
  \code{\link{scopus2df}}
}
\concept{converting functions}
