% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{rBeta.4P}
\alias{rBeta.4P}
\title{Random Number Generation under the Four-Parameter Beta Probability Density Distribution.}
\usage{
rBeta.4P(n, l, u, alpha, beta)
}
\arguments{
\item{n}{Number of draws.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The alpha (first) shape parameter.}

\item{beta}{The beta (second) shape parameter.}
}
\value{
A vector with length \code{n} of random values drawn from the Four-Parameter Beta Distribution.
}
\description{
Function for generating random numbers from a specified Four-Parameter Beta Distribution.
}
\examples{
# Assume some variable follows a four-parameter Beta distribution with
# location parameters l = 0.25 and u = 0.75, and shape parameters alpha = 5
# and beta = 3. To draw a random value from this distribution using
# rBeta.4P():
rBeta.4P(n = 1, l = 0.25, u = 0.75, alpha = 5, beta = 3)
}
