% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumatraInitialize.R
\name{sumatraInitialize}
\alias{sumatraInitialize}
\title{Set useful Sumatra PDF Viewer default settings}
\usage{
sumatraInitialize(
  path = sub("pandoc$", "sumatra", Sys.getenv("RSTUDIO_PANDOC")),
  roampath = paste0(Sys.getenv("APPDATA"), "/SumatraPDF"),
  openfolder = TRUE
)
}
\arguments{
\item{path}{Folder (not file) that contains "SumatraPDF.exe". 
You need file writing permissions in the folder.
DEFAULT: extracted from \code{\link{Sys.getenv}("RSTUDIO_PANDOC")}, e.g.
"C:/Program Files/RStudio/bin/sumatra"}

\item{roampath}{if not NULL, both files are also copied to this path, 
e.g. C:/Users/berry/AppData/Roaming/SumatraPDF.
DEFAULT: SumatraPDF folder at \code{\link{Sys.getenv}("APPDATA")}}

\item{openfolder}{Logical: Open folder after writing the files?
Uses \code{\link{openFile}()}. DEFAULT: TRUE}
}
\value{
path, invisibly
}
\description{
Set useful Sumatra PDF Viewer default settings. This will likely only work on windows.
At the given \code{path} with "SumatraPDF.exe", this creates two settings files.
Existing files are renamed ("_old_n" appended), not overwritten.\cr
Creates "sumatrapdfrestrict.ini" with \code{SavePreferences = 1} and \code{FullscreenAccess = 1}.\cr
Creates "SumatraPDF-settings.txt" with \code{ShowToc = false} and \code{DefaultDisplayMode = single page}.
\code{UiLanguage} gets filled in by Sumatra itself upon first opening.
}
\examples{
# sumatraInitialize() # only run in interactive mode

}
\seealso{
\code{\link{openPDF}}\cr
\url{https://www.sumatrapdfreader.org/settings/settings.html}\cr
\url{https://github.com/sumatrapdfreader/sumatrapdf/blob/master/docs/sumatrapdfrestrict.ini}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2020
}
\keyword{file}
