% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFile.R
\name{checkFile}
\alias{checkFile}
\title{check file existence}
\usage{
checkFile(file, warnonly = FALSE, trace = TRUE, pwd = TRUE)
}
\arguments{
\item{file}{Filename(s) as character string to be checked for existence.}

\item{warnonly}{Logical: Only issue a \code{\link{warning}} instead of an
error with \code{\link{stop}}? DEFAULT: FALSE}

\item{trace}{Logical: Add function call stack to the message? DEFAULT: TRUE}

\item{pwd}{Logical: Print working directory in message? DEFAULT: TRUE}
}
\value{
TRUE/FALSE, invisibly
}
\description{
check whether files exist and give a useful error/warning/message
}
\examples{
is.error( checkFile("FileThatDoesntExist.txt")  )
checkFile("FileThatDoesntExist.txt", warnonly=TRUE)
checkFile("FileThatDoesntExist.txt", warnonly=TRUE, trace=FALSE)

checkFile("./", warnonly=TRUE)
checkFile(c("./",".//"), warnonly=TRUE)

\dontrun{## Excluded from CRAN checks because of file creation
# Vectorized:
file.create("DummyFile2.txt")
checkFile(paste0("DummyFile",1:3,".txt"), warnonly=TRUE)
is.error(checkFile(paste0("DummyFile",1:3,".txt") ), TRUE, TRUE)
file.remove("DummyFile2.txt")

is.error(compareFiles("dummy.nonexist", "dummy2.nonexist"), TRUE, TRUE)
is.error(checkFile("dummy.nonexist"), TRUE, TRUE)
}

dingo <- function(k="brute.nonexist", trace=TRUE)
         checkFile(k, warnonly=TRUE, trace=trace)
dingo()
dingo("dummy.nonexist")

upper <- function(h, ...) dingo(c(h, "dumbo.nonexist"), ...)
upper("dumbo2.nonexist")
upper(paste0("dumbo",2:8,".nonexist"))
upper(paste0("dumbo",2:8,".nonexist"), trace=FALSE)


}
\seealso{
\code{\link{file.exists}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\keyword{file}
