% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload_results.R
\name{create_bundle}
\alias{create_bundle}
\alias{upload_results}
\title{Upload benchmark results}
\usage{
create_bundle(results, filename = NULL, args = NULL)

upload_results(results, url = "http://www.mas.ncl.ac.uk/~ncsg3/form.php",
  args = NULL)
}
\arguments{
\item{results}{Benchmark results. Probably obtained from 
\code{benchmark_std()} or \code{benchmark_io()}.}

\item{filename}{default \code{NULL}. A character vector of where to 
store the results (in an .rds file). If \code{NULL}, results are not saved.}

\item{args}{Default \code{NULL}. A list of arguments to 
be passed to \code{get_sys_details()}.}

\item{url}{The location of where to upload the results.}
}
\description{
This function uploads the benchmarking results. 
These results will then be incorparated
in future versions of the package.
}
\examples{
## Run benchmarks
\dontrun{
res = benchmark_std()
upload_results(res)
}
}

