% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_time.R
\name{system_time}
\alias{system_time}
\title{Return Process CPU and real time that an expression used.}
\usage{
system_time(expr)
}
\arguments{
\item{expr}{A expression to be timed.}
}
\value{
A \link{bench_time} object with two values.
\itemize{
\item \code{process} - The process CPU usage of the expression evaluation.
\item \code{real} - The wallclock time of the expression evaluation.
}
}
\description{
Return Process CPU and real time that an expression used.
}
\details{
On some systems (such as macOS) the process clock has lower
precision than the realtime clock, as a result there may be cases where the
process time is larger than the real time for fast expressions.
}
\examples{
# This will use ~.5 seconds of real time, but very little process time.
system_time(Sys.sleep(.5))
}
