% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta}
\alias{meta}
\alias{setmeta}
\title{Retrieve and set metadata}
\usage{
meta(x)

setmeta(x, new)
}
\arguments{
\item{x}{\link{behavr} object}

\item{new}{a new metadata table}
}
\value{
a \link{data.table} representing the metadata in \code{x}
}
\description{
This function returns the metadata from a \link{behavr} table.
}
\examples{
set.seed(1)
met <- data.table::data.table(id = 1:5,
                              condition = letters[1:5],
                              sex = c("M", "M", "M", "F", "F"),
                              key = "id")
data <- met[,
            list(t = 1L:100L,
                 x = rnorm(100),
                 y = rnorm(100),
                 eating = runif(100) > .5 ),
             by = "id"]

d <- behavr(data, met)
## show metadata
meta(d)
# same as:
d[meta = TRUE]
## set metadata
m <- d[meta = TRUE]
# only id > 2 is kept
setmeta(d, m[id < 3])
meta(d)
}
\seealso{
\itemize{
\item \link{behavr} -- the documentation of the \code{behavr} object
\item \link{xmv} -- to join metavariables
}
}
