% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_model_to_tracelog_xml.R
\name{tree_model_to_tracelog_xml}
\alias{tree_model_to_tracelog_xml}
\title{Internal function}
\usage{
tree_model_to_tracelog_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Creates the tree models' XML for the tracelog section.
That is, all XML tags that have the word 'tree' in them.
}
\note{
use site_models just because it contains all IDs
}
\examples{
# <logger id="tracelog" ...>
#'   # Here
# </logger>
}
\seealso{
the complete tracelog section is created
  by \code{\link{create_tracelog_xml}}
}
\author{
Richèl J.C. Bilderbeek
}
