% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_inference_model_filenames.R
\name{rename_inference_model_filenames}
\alias{rename_inference_model_filenames}
\title{Rename the filenames in an inference model}
\usage{
rename_inference_model_filenames(inference_model, rename_fun)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{rename_fun}{a function to rename a filename,
as can be checked by \link{check_rename_fun}. This function should
have one argument, which will be a filename or \link{NA}. The
function should \link{return} one filename (when passed one filename) or
one \link{NA} (when passed one \link{NA}).
Example rename functions are:
\itemize{
  \item \link{get_remove_dir_fun} get a function that removes the directory
    paths from the filenames, in effect turning these into local files
  \item \link{get_replace_dir_fun} get a function that replaces the directory
    paths from the filenames
  \item \link{get_remove_hex_fun} get a function that removes the
    hex string from filenames.
    For example, \code{tracelog_82c1a522040.log} becomes \code{tracelog.log}
}}
}
\value{
an inference model with the renamed filenames
}
\description{
Rename the filenames in an inference model
}
\examples{

inference_model <- create_inference_model()
inference_model$mcmc$tracelog$filename <- "trace.log"
inference_model$mcmc$screenlog$filename <- "screen.log"
inference_model$mcmc$treelog$filename <- "tree.log"
inference_model$tipdates_filename <- "tipdates.csv"

# Nah, put the files in a folder
inference_model <- rename_inference_model_filenames(
  inference_model = inference_model,
  rename_fun = get_replace_dir_fun("/home/john")
)

# Nah, put the files in anoth folder
inference_model <- rename_inference_model_filenames(
  inference_model = inference_model,
  rename_fun = get_replace_dir_fun("/home/doe")
)

# Nah, store the files locally
rename_inference_model_filenames(
  inference_model = inference_model,
  rename_fun = get_remove_dir_fun()
)
}
