% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_file_from_model.R
\name{create_beast2_input_file_from_model}
\alias{create_beast2_input_file_from_model}
\title{Create a BEAST2 input file from an inference model}
\usage{
create_beast2_input_file_from_model(
  input_filename,
  output_filename,
  inference_model = create_inference_model()
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
nothing
}
\description{
Create a BEAST2 input file from an inference model
}
\examples{
  # Get an example FASTA file
  input_filename <- get_fasta_filename()

  # The file created by beautier, a BEAST2 input file
  output_filename <- tempfile()

  create_beast2_input_file_from_model(
    input_filename,
    output_filename
  )
  testthat::expect_true(file.exists(output_filename))
}
\seealso{
use \link{create_beast2_input_from_model} to
get the BEAST2 input file as text

See \code{\link{create_site_model}} for examples with
different site models.
See \code{\link{create_clock_model}} for examples
with clock models.
See \code{\link{create_tree_prior}} for examples with
different tree priors.
See \code{\link{create_mcmc}} for examples with
a different MCMC setup.
Use \link{create_beast2_input_file} to do the same with the elements
of an inference model.
}
\author{
Richèl J.C. Bilderbeek
}
