% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_file.R
\name{create_beast2_input_file}
\alias{create_beast2_input_file}
\title{Create a BEAST2 input file}
\usage{
create_beast2_input_file(
  input_filename,
  output_filename,
  site_model = create_jc69_site_model(),
  clock_model = create_strict_clock_model(),
  tree_prior = create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = create_mcmc(),
  beauti_options = create_beauti_options(),
  tipdates_filename = NA,
  input_filenames = "deprecated",
  site_models = "deprecated",
  clock_models = "deprecated",
  tree_priors = "deprecated",
  mrca_priors = "deprecated",
  posterior_crown_age = "deprecated"
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}

\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{posterior_crown_age}{deprecated}
}
\value{
nothing
}
\description{
Create a BEAST2 input file
}
\examples{
library(testthat)

# Get an example FASTA file
input_filename <- get_fasta_filename()

# The file created by beautier, a BEAST2 input file
output_filename <- tempfile(pattern = "beast2", fileext = ".xml")

create_beast2_input_file(
  input_filename,
  output_filename
)
expect_true(file.exists(output_filename))
}
\seealso{
Use \link{create_beast2_input_file_from_model} to do the same with an
  inference model.
  See \code{\link{create_site_model}} for examples with
  different site models. See \code{\link{create_clock_model}} for examples
  with clock models. See \code{\link{create_tree_prior}} for examples with
  different tree priors. See \code{\link{create_mcmc}} for examples with
  a different MCMC setup.
}
\author{
Richèl J.C. Bilderbeek
}
