% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_1_12.R
\name{create_beast2_input_1_12}
\alias{create_beast2_input_1_12}
\title{Create a BEAST2 XML input text, interface of v1.12}
\usage{
create_beast2_input_1_12(input_filenames,
  site_models = create_jc69_site_models(ids = get_ids(input_filenames)),
  clock_models = create_strict_clock_models(ids = get_ids(input_filenames)),
  tree_priors = create_yule_tree_priors(ids = get_ids(input_filenames)),
  mcmc = create_mcmc(), misc_options = create_misc_options(),
  fixed_crown_ages = rep(FALSE, times = length(input_filenames)),
  initial_phylogenies = rep(NA, length(input_filenames)))
}
\arguments{
\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mcmc}{one mcmc object,
as returned by \code{\link{create_mcmc}}}

\item{misc_options}{one misc_options object,
as returned by \code{\link{create_misc_options}}}

\item{fixed_crown_ages}{one or more booleans to determine if the
phylogenies' crown ages are fixed.
If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{initial_phylogenies}{one or more MCMC chain's initial phylogenies.
Each one set to NA will result in BEAST2 using a random phylogeny. Else
the phylogeny is assumed to be of class ape::phylo.}
}
\description{
Create a BEAST2 XML input text, interface of v1.12
}
\examples{
  create_beast2_input_file_1_12(
    input_filenames = get_fasta_filename(),
    "my_beast.xml"
  )
}
\seealso{
\code{\link{create_beast2_input_file}} shows more examples
}
\author{
Richel J.C. Bilderbeek
}
