% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_path.R
\name{get_beastier_path}
\alias{get_beastier_path}
\title{Get the full path of a file in the \code{inst/extdata} folder}
\usage{
get_beastier_path(filename)
}
\arguments{
\item{filename}{the file's name, without the path}
}
\value{
the full path to the filename. Will \code{stop} if the file
  is absent in the \code{inst/extdata} folder
}
\description{
Get the full path of a file in the \code{inst/extdata} folder
}
\examples{
  library(testthat)

  expect_true(is.character(get_beastier_path("beast2_example_output.log")))
  expect_true(is.character(get_beastier_path("beast2_example_output.trees")))
  expect_true(is.character(get_beastier_path("beast2_example_output.xml")))
  expect_true(
    is.character(get_beastier_path("beast2_example_output.xml.state"))
  )
}
\seealso{
for more files, use \code{\link{get_beastier_paths}}
}
\author{
Richèl J.C. Bilderbeek
}
