% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_subgrp.R
\name{bzGetSubgrpRaw}
\alias{bzGetSubgrpRaw}
\title{Get subgroup treatment effect estimation and variance}
\usage{
bzGetSubgrpRaw(data.all, var.resp, var.trt, var.cov, var.censor,
  resptype = c("continuous", "binary", "survival"))
}
\arguments{
\item{data.all}{subject level dataset}

\item{var.resp}{column name in \code{data.all} for response}

\item{var.trt}{column name  in \code{data.all} for treatment assignment}

\item{var.cov}{array of column names in \code{dat.all} that corresponds to binary or
ordinal baseline covaraites}

\item{var.censor}{column name in \code{data.all} for censoring if the
response is time to event data}

\item{resptype}{type of response. The options are \code{binary},
\code{continuous} or \code{survial}}
}
\value{
A dataframe with treatment effect estimation and variance for each subgroup
}
\description{
Compute subgroup treatment effect estimation and variance from subject level data.
}
\examples{

\dontrun{
var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
subgrp.effect <- bzGetSubgrpRaw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);}

}
