% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beaSearch.r
\name{beaSearch}
\alias{beaSearch}
\title{Search a selection of indexed BEA data table names, series labels, and series codes.}
\usage{
beaSearch(searchTerm, beaKey = NULL, asHtml = FALSE)
}
\arguments{
\item{searchTerm}{A word or phrase of class 'character' to be found in BEA datasets}

\item{beaKey}{Character string representation of user API key. Necessary for first time use and updates; recommended for anything beyond one-off searches from the console.}

\item{asHtml}{Option to return results as DT markup, viewable in browser.  Allows search WITHIN YOUR ALREADY-FILTERED RESULTS ONLY. Requires package 'DT' to be installed.}
}
\value{
An object of class 'data.table' with information about all indexed sets in which the search term was found.
}
\description{
Searches indexed dataset table name, label, and series codes.  CAUTION: Currently only works with NATIONAL datasets (NIPA, NIUnderlyingDetail), temporarily excluding FixedAssets, and REGIONAL datasets (RegionalData, RegionalProduct, RegionalIncome)
}
\examples{
beaSearch('gross domestic product', asHtml = TRUE)
}
\keyword{search}

