% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bea2List.r
\name{bea2List}
\alias{bea2List}
\title{Convert BEA API httr response payload to list}
\usage{
bea2List(beaPayload, isMeta = FALSE)
}
\arguments{
\item{beaPayload}{An object with httr class 'response' from call to BEA API}

\item{isMeta}{Special parameter meant to interact with metadata functions (default: FALSE)}
}
\value{
An object of class 'list' of several dimensions. View list structure using 'str(yourList)'.
}
\description{
Convert BEA API httr response payload to list
}
\examples{
userSpecList <- list('UserID' = 'yourKey' ,
								'Method' = 'GetData',
								'datasetname' = 'NIPA',
								'Frequency' = 'A',
								'TableID' = '68',
								'Year' = 'X')
resp <- beaGet(userSpecList, asTable = FALSE)
BL <- bea2List(resp)
}

