% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDA.R
\name{BDA}
\alias{BDA}
\title{Beta Drift Anaylsis}
\usage{
BDA(data, spec, horizon = round(nrow(data) * 0.5) - 1, min.hor = 21,
  max.hor = 750, family = gaussian, doplot = TRUE, ...)
}
\arguments{
\item{data}{an xts object containing all relevant time series. Please note that
\code{BDA} assumes that the data is ordered so that the most recent data is at the
tail of the matrix.}

\item{spec}{contains the formula for the baseline model.}

\item{horizon}{the time period for which the paramters should be estimated.
(e.g. 250 for a year, assuming daily data). By default, half of the data length is used.}

\item{min.hor}{the minimum horizon used in the analysis, by default one month,
assuming daily data (21 obs if available).}

\item{max.hor}{the maximum horizon used in the analysis, by default three years,
assuming daily data (750 obs if available)}

\item{family}{type of regression family passed to the \code{glm} function.
For further details on family types refer to \code{\link{family}}. Please note
that at this point the built-in plotting does not support all families.}

\item{doplot}{logical. If \code{TRUE}, the function returns diagnostic
plots for each parameter.}

\item{...}{aditional commands passed to the \code{glm} function.}
}
\value{
a list with 8 elements:
\item{CALL}{function call}
\item{base.model}{baseline model}
\item{tdrift}{xts matrix containing historical estimates of baseline model}
\item{tdrift.se}{xts matrix containing historical standard errors of baseline model}
\item{hdrift}{matrix containing estimates of baseline model
with varying horizon lengths}
\item{hdrift.se}{matrix containing standard errors of
baseline model with varying horizon lengths}
\item{jackknife}{jackknife procedure of object class lm.influence}
\item{sumstats}{list containing various summary statistics}
}
\description{
\code{BDA} performs a range of parameter instability diagnostics
for financial multi-factor models and returns data frames containing the
drifting parameters and their standard errors, a list of summary statistics
and an overview plot for each factor.
}
\details{
\code{BDA} performs a threefold analyis of a user-specified baseline model.
First, \code{BDA} performs a rolling regression across the entire data frame
where \code{horizon} determines the regression window size. The function includes
all rolling parameter estimates and standard errors in the output, so users
can access them using \code{$tdrift} and \code{$tdrift.se} respectively.

Second, \code{BDA} estimates the baseline model parameters with estimation
windows of varying length from (\code{min.hor} to \code{max.hor}). Users can access
the resulting parameter estimates and standard errors using \code{$hdrift} and
\code{$hdrift.se} respectively.

Third, \code{BDA} checks the baseline model for observations that have a noteworthy 
impact on the parameter estimate.

For further details on the summary statistics output and plotting, please
reference \code{\link{summary.BDA}} and \code{\link{plot.BDA}} respectively.

Although \code{BDA} was primarily developed to analyze financial multi-factor
models, it is capable to analyze any model fit, as long as the underlying data
is of class \code{xts}. However, \code{BDA} was developed with large datasets
in mind, so that very small datasets might produce errors or non-sensical results.
}
\examples{
\dontrun{
###################################################
####   3-Factor Stock Example: ExxonMobil      ####
###################################################

results1 <- BDA(data = FFfactors, 
                spec = (XOM~Mkt.RF + SMB + HML),
                horizon = 250, doplot = TRUE)

###################################################
#### 5-Factor Active Fund Example: BlackRock   ####
###################################################

results2 <- BDA(data = FFfactors, 
                spec = (MDLRX~Mkt.RF + SMB + HML + RMW + CMA),
                horizon = 250, doplot = TRUE)

###################################################
####   1-Factor Index Fund Example: Vanguard   ####
###################################################

results3 <- BDA(data = FFfactors, spec = (VOO~SP500),
                horizon = 250, doplot = FALSE)
}
###################################################
####        CRAN-compatible example            ####
###################################################

results <- BDA(data = FFfactors[nrow(FFfactors):(nrow(FFfactors)-300),], 
               spec = (VOO~SP500),horizon = 250, doplot = TRUE)
message("NOTE: This is a shortened example. Reference the manual for more complex examples")

}
\author{
Markus Peter Auer <mp.auer@meanerreversion.com>
}

