% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindHashtagPipe.R
\docType{class}
\name{FindHashtagPipe}
\alias{FindHashtagPipe}
\title{Class to find and/or remove the hashtags on the data field of an Instance}
\usage{
FindHashtagPipe
}
\description{
This class is responsible of detecting the existing hashtags in the
\strong{data} field of each \code{\link{Instance}}. Identified hashtags are
stored inside the \strong{hashtag} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline hashtag removement.
}
\section{Constructor}{

\preformatted{
FindHashtagPipe$new(propertyName = "hashtag",
                    alwaysBeforeDeps = list(),
                    notAfterDeps = list())
}

\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The regular expression indicated in the \code{hashtagPattern}
variable is used to identify hashtags.
}

\section{Note}{

\code{\link{FindHashtagPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/remove the hashtags.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance, removeHashtag = TRUE)}
}
\item{\emph{Value}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
\item{\strong{removeHashtag:}}{
(\emph{logical}) indicates if the hashstags are removed
}
}
}
}
}

\item{\bold{findHashtag:}}{
finds the hashtags in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findHashtag(data)}
}
\item{\emph{Value:}}{
list with hashtags found.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to search the hashtags.
}
}
}
}
}

\item{\bold{removeHashtag:}}{
removes the hashtags in the data.
\itemize{
\item{\emph{Usage:}}{
\code{removeHashtag(data)}
}
\item{\emph{Value:}}{
the data with hashtags removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to remove the hashtags.
}
}
}
}
}
}
}

\section{Public fields}{

\itemize{
\item{\bold{hashtagPattern:}}{
 (\emph{character}) regular expression to detect hashtags.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{PipeGeneric}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
