% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_filter_out_flags.R
\name{bdc_filter_out_flags}
\alias{bdc_filter_out_flags}
\title{Remove columns with the results of data quality tests}
\usage{
bdc_filter_out_flags(data, col_to_remove = "all")
}
\arguments{
\item{data}{data.frame. Containing columns to be removed.}

\item{col_to_remove}{logical. Which columns should be removed? Default =
"all", which means that all columns containing the results of data quality
tests are removed.}
}
\value{
A data.frame without columns specified in 'col_to_remove'.
}
\description{
This function filters out columns containing the results of data quality
tests (i.e., columns starting with '.') or other columns specified.
}
\examples{
x <- data.frame(
  database_id = c("test_1", "test_2", "test_3", "test_4", "test_5"),
   kindom = c("Plantae", "Plantae", "Animalia", "Animalia", "Plantae"),
  .bdc_scientificName_empty = c(TRUE, TRUE, TRUE, FALSE, FALSE),
  .bdc_coordinates_empty = c(TRUE, FALSE, FALSE, FALSE, FALSE),
  .bdc_coordinates_outOfRange = c(TRUE, FALSE, FALSE, FALSE, FALSE),
  .summary = c(TRUE, FALSE, FALSE, FALSE, FALSE)
)

bdc_filter_out_flags(
  data = x,
  col_to_remove = "all"
)

}
