% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bcrp_data.R
\name{get_bcrp_data}
\alias{get_bcrp_data}
\title{Perform an API request to BCRPData}
\usage{
get_bcrp_data(
  codes,
  from = NA,
  to = NA,
  request_strategy = c("sequential", "parallel")
)
}
\arguments{
\item{codes}{A character vector with valid BCRPData series codes, see the \code{\link[=get_bcrp_metadata]{get_bcrp_metadata()}} function. Required.}

\item{from}{A character vector of length 1, usually a year see Details. Optional.}

\item{to}{A character vector of length 1. Must be greater than the
\code{from} argument. Optional.}

\item{request_strategy}{Either "sequential" (default) or "parallel". This defines the strategy to be followed when making requests for more than one code. Visit \href{https://httr2.r-lib.org/reference/index.html#perform-multiple-requests}{httr2} for more details.}
}
\value{
Data frame with code-level observations.
}
\description{
Perform an API request to BCRPData
}
\details{
It is possible to specify only the \code{from} or \code{to} arguments in which case the request to the BCRPData API would only take into consideration the non-missing argument, if both are ommited the API will respond with the latest data.

BCRPData has data of different frequencies, it's important to consider that when defining the \code{from} and \code{to} arguments. Here's a list you can use to define the most suitable values to the \code{from} and \code{to} arguments.
\itemize{

\item{Yearly: Provide a year, e.g 2018}
\item{Quarterly: Provide a year followed by a hyphen followed by the quarter in its numerical value, e.g 2018-2}
\item{Monthly: Provide a year followed by a hyphen followed by the month in its numerical value, e.g 2018-5}
\item{Daily: Provide a year followed by a hyphen followed by the month and followed by the day, e.g 2018-5-5}
}
This function will try to get all the valid codes you provided in its \code{codes} argument, if one of the requests fails it will stop its execution for all the codes and return an error, pointing out which codes caused this.
}
\examples{
codes <- c("PN00009MM", "PN00002MM", "PN01270PM", "PD39557DA")
# Will get you the most recent data for these codes
# as you have not provided the `from` and `to` arguments.
get_bcrp_data(codes = codes)

# You can also provide the range of dates
# through the `from` and `to` arguments.
get_bcrp_data(codes = codes, from = "2015-01", to = "2020-01")

# If needed, you can sometimes speed up your data API calls
# by performing them in parallel. In this example we are
# querying just 5 codes so the benefits of parallelism does not
# outweigh its cost, making the request slower.
\dontrun{
get_bcrp_data(codes = codes, request_strategy = "parallel")
}
}
\author{
Julio Collazos.
}
