% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posteriorDiscard.DP}
\alias{posteriorDiscard.DP}
\title{Update a "DP" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{DP}(obj, ss = NULL, z, w = NULL, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{ss}{Sufficient statistics of x of the "BasicBayesian" object, must be a list of sufficient statistics for each of the observations. Use sufficientStatistics(...,foreach=TRUE) to generate ss. See examples.}

\item{z}{integer, the partition label of the parameter space where the observation x is drawn from.}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss".
}
\description{
For the model structure:
     \deqn{pi|alpha \sim DP(alpha,U)}
     \deqn{z|pi \sim Categorical(pi)}
     \deqn{theta_z|psi \sim H0(psi)}
     \deqn{x|theta_z,z \sim F(theta_z)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "DP" object is simply a combination of a "CatDP" object (see \code{?CatDP}) and an object of any "BasicBayesian" type.\cr
Contrary to posterior(), this function will update the prior knowledge by removing the information of observed samples x. The model structure and prior parameters are stored in a "CatDP" object, the prior parameters in this object will be updated after running this function.
}
\examples{
x <- rnorm(40)
z <- sample(1L:10L,size = 40,replace = TRUE)
obj <- DP()
ss <- sufficientStatistics(obj = obj,x=x,foreach = TRUE) #must use foreach=TRUE
for(i in 1L:length(z)) posterior(obj = obj,ss = ss[[i]],z=z[i])
obj
for(i in 1L:length(z)) posteriorDiscard(obj = obj,ss = ss[[i]],z=z[i])
obj
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}},\code{\link{posteriorDiscard.DP}},\code{\link{sufficientStatistics.DP}}
}
