% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{posterior}
\alias{posterior}
\title{update the prior distribution with sufficient statistics}
\usage{
posterior(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None, or an error message if the update fails.
}
\description{
This is a generic function that will update the prior distribution of a "BayesianBrick" object by adding information of the observation's sufficient statistics. i.e. for the model structure:
     \deqn{theta|gamma \sim H(gamma)}
     \deqn{x|theta \sim F(theta)}
update gamma to gamma_posterior by adding the information of x to gamma.\cr
For a given sample set x or it's sufficient statistics ss, and a Bayesian bricks object obj, \code{posterior()} will update the posterior parameters in obj for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
\code{posterior()} will update m and S in obj.
See \code{?posterior.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{mu \sim Gaussian(m,S)}
Sigma is known.
\code{posterior()} will update m and S in obj.
See \code{?posterior.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
mu is known.
\code{posterior()} will update v and S in obj.
See \code{?posterior.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
\deqn{mu \sim Gaussian(m,Sigma/k)}
\code{posterior()} will update m, k, v and S in obj.
See \code{?posterior.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x \sim Gaussian(X beta,sigma^2)}
\deqn{sigma^2 \sim InvGamma(a,b)}
\deqn{beta \sim Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
\code{posterior()} will update m, V, a and b in obj.
See \code{?posterior.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim Dirichlet(alpha)}
\code{posterior()} will update alpha in obj.
See \code{?posterior.CatDirichlet} for details.
}
\subsection{class(obj)="CatDP"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim DirichletProcess(alpha)}
\code{posterior()} will update alpha in obj.
See \code{?posterior.CatDP} for details.
}
\subsection{class(obj)="DP"}{
Where
     \deqn{pi|alpha \sim DP(alpha,U)}
    \deqn{z|pi \sim Categorical(pi)}
     \deqn{theta_z|psi \sim H0(psi)}
     \deqn{x|theta_z,z \sim F(theta_z)}
\code{posterior()} will update alpha and psi in obj.
See \code{?posterior.DP} for details.
}
\subsection{class(obj)="HDP"}{
Where
     \deqn{G|gamma \sim DP(gamma,U)}
     \deqn{pi_j|G,alpha \sim DP(alpha,G), j = 1:J}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G \sim Categorical(G),\textrm{ if z is a sample from the base measure G}}
     \deqn{theta_k|psi \sim H0(psi)}
\code{posterior()} will update gamma, alpha and psi in obj.
See \code{?posterior.HDP} for details.
}
\subsection{class(obj)="HDP2"}{
Where
     \deqn{G |eta \sim DP(eta,U)}
     \deqn{G_m|gamma,G \sim DP(gamma,G), m = 1:M}
     \deqn{pi_{mj}|G_m,alpha \sim DP(alpha,G_m), j = 1:J_m}
     \deqn{z|pi_{mj} \sim Categorical(pi_{mj})}
     \deqn{k|z,G_m \sim Categorical(G_m),\textrm{ if z is a sample from the base measure } G_m}
     \deqn{u|k,G \sim Categorical(G),\textrm{ if k is a sample from the base measure} G}
     \deqn{theta_u|psi \sim H0(psi)}
     \deqn{x|theta_u,u \sim F(theta_u)}
\code{posterior()} will update eta, gamma, alpha and psi in obj.
See \code{?posterior.HDP2} for details.
}
}
\seealso{
\code{\link{posterior.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{posterior.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{posterior.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{posterior.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{posterior.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{posterior.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{posterior.CatDP}} for Categorical-DP conjugate structure ...
}
