% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MPE.GaussianNIW}
\alias{MPE.GaussianNIW}
\title{Mean Posterior Estimate (MPE) of a "GaussianNIW" object}
\usage{
\method{MPE}{GaussianNIW}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A named list, the MPE estimate of mu and Sigma.
}
\description{
Generate the MPE of (mu,Sigma) in following GaussianNIW structure:
     \deqn{mu,Sigma|m,k,v,S ~ NIW(m,k,v,S)}
     \deqn{x|mu,Sigma ~ Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
The MPE estimates are:
\itemize{
  \item (mu_MPE,Sigma_MPE) = E(mu,Sigma|m,k,v,S,x)
}
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}
}
