% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{rPosteriorPredictive}
\alias{rPosteriorPredictive}
\title{Generate random samples from the posterior predictive distribution}
\usage{
rPosteriorPredictive(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix or vector of random samples
}
\description{
This is a generic function that will generate random samples from the posterior predictive distribution. i.e. for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
generate x_new from the posterior predictive distribution of x|gamma.
}
\seealso{
\code{\link{rPosteriorPredictive.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{rPosteriorPredictive.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{rPosteriorPredictive.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{rPosteriorPredictive.CatDP}} for Categorical-DP conjugate structure ...
}
