% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{methods}
\name{initialize,bbl-method}
\alias{initialize,bbl-method}
\title{Instantiate \code{bbl} object}
\usage{
\S4method{initialize}{bbl}(.Object, data, predictors = NULL,
  groups = NULL, y = "y", ...)
}
\arguments{
\item{.Object}{Object of class \code{bbl} to be created.}

\item{data}{Data frame of training data. Expected to contain both
predictor and response variables in columns and instances
in rows.}

\item{predictors}{List of predictor factor levels. If not provided,
will be inferred from \code{data} columns with names not equal
to \code{y}.}

\item{groups}{Vector of characters for response factor levels. If not
provided, will be inferred from \code{data} response column
named \code{y}.}

\item{y}{Column name in \code{data} containing response data. Can also
be column number.}

\item{...}{Other parameters (not used).}
}
\value{
Object of class \code{bbl}.
}
\description{
Creates \code{bbl} object based on arguments provided.
}
\details{
Note that with argument \code{data} only, \code{predictor}
factor levels will be ordered by default. Also some of predictors
may have values in \code{data} less than expected, which would
result in fewer levels of \code{predictor} levels. By explicitly
providing \code{predictors}, this default behavior can be overriden.
Predictors in \code{data} with a single factor level will be removed.
Same applies to \code{groups} for response levels.
}
\examples{
## Factors model
titanic <- freq2raw(as.data.frame(Titanic), Freq='Freq')
summary(titanic)
model <- bbl(data=titanic, y='Survived')
model
}
