% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_density_at.R
\name{density_at}
\alias{density_at}
\title{Probability of a Given Point}
\usage{
density_at(posterior, x, precision = 2^10)
}
\arguments{
\item{posterior}{Vector representing a posterior distribution.}

\item{x}{The value of which to get the approximate probability.}

\item{precision}{Number of points for density estimation. See the \code{n} parameter in \link[=density]{density}.}
}
\description{
Compute the density of a given point of a distribution.
}
\examples{
library(bayestestR)
posterior <- rnorm_perfect(n = 10)
density_at(posterior, 0)
density_at(posterior, c(0, 1))
}
