% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{coef}
\alias{coef}
\alias{coef.bayesianVARs_bvar}
\title{Extract VAR coefficients}
\usage{
\method{coef}{bayesianVARs_bvar}(object, ...)
}
\arguments{
\item{object}{A \code{bayesianVARs_bvar} object obtained from \code{\link[=bvar]{bvar()}}.}

\item{...}{Currently ignored.}
}
\value{
Returns a numeric array of dimension \eqn{M \times K \times draws},
where M is the number of time-series, K is the number of covariates per
equation (including the intercept) and draws is the number of stored
posterior draws.
}
\description{
Extracts posterior draws of the VAR coefficients from a VAR
model estimated with \code{\link[=bvar]{bvar()}}.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Extract posterior draws of VAR coefficients
bvar_coefs <- coef(mod)
}
\seealso{
\code{\link[=summary.bayesianVARs_draws]{summary.bayesianVARs_draws()}}, \code{\link[=vcov.bayesianVARs_bvar]{vcov.bayesianVARs_bvar()}}.
}
