% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{predict.bayesianVARs_bvar}
\alias{predict.bayesianVARs_bvar}
\title{Predict method for Bayesian VARs}
\usage{
\method{predict}{bayesianVARs_bvar}(
  object,
  ahead = 1L,
  each = 1L,
  stable = TRUE,
  simulate_predictive = TRUE,
  LPL = FALSE,
  Y_obs = NA,
  LPL_VoI = NA,
  ...
)
}
\arguments{
\item{object}{A \code{bayesianVARs_bvar} object, obtained from \code{\link[=bvar]{bvar()}}.}

\item{ahead}{Integer vector (or coercible to such), indicating the number of
steps ahead at which to predict.}

\item{each}{Single integer (or coercible to such) indicating how often should
be drawn from the posterior predictive distribution for each draw that has
been stored during MCMC sampling.}

\item{stable}{logical indicating whether to consider only those draws from
the posterior that fulfill the 'stable' criterion. Default is \code{TRUE}.}

\item{simulate_predictive}{logical, indicating whether the posterior
predictive distribution should be simulated.}

\item{LPL}{logical indicating whether \code{ahead}-step-ahead log predictive
likelihoods should be computed. If \code{LPL=TRUE}, \code{Y_obs} has to be
specified.}

\item{Y_obs}{Data matrix of observed values for computation of log predictive
likelihood. Each of \code{ncol(object$Yraw)} columns is assumed to contain a
single time-series of length \code{length(ahead)}.}

\item{LPL_VoI}{either integer vector or character vector of column-names
indicating for which subgroup of time-series in \code{object$Yraw} a joint log
predictive likelihood shall be computed.}

\item{...}{Currently ignored!}
}
\value{
Object of class \code{bayesianVARs_predict}, a list that may contain the
following elements:
\itemize{
\item \code{predictions} array of dimensions
\code{c(length(ahead), ncol(object$Yraw), each * dim(object$PHI)[3])}
containing the simulations from the predictive density (if
\code{simulate_predictive=TRUE}).
\item \code{LPL} vector of length \code{length(ahead)} containing the
log-predictive-likelihoods (taking into account the joint distribution of
all variables) (if \code{LPL=TRUE}).
\item \code{LPL_univariate} matrix of dimension \verb{c(length(ahead), ncol(object$Yraw)}
containing the marginalized univariate log-predictive-likelihoods of each
series (if \code{LPL=TRUE}).
\item \code{LPL_VoI} vector of length \code{length(ahead)} containing the
log-predictive-likelihoods for a subset of variables (if \code{LPL=TRUE} and
\code{LPL_VoI != NA}).
\item \code{Yraw} matrix containing the data used for the estimation of the VAR.
\item \code{LPL_draws} matrix containing the simulations of the
log-predictive-likelihood (if \code{LPL=TRUE}).
\item \code{PL_univariate_draws} array containing the simulations of the univariate
predictive-likelihoods (if \code{LPL=TRUE}).
\item \code{LPL_sub_draws} matrix containing the simulations of the
log-predictive-likelihood for a subset of variables (if \code{LPL=TRUE} and
\code{LPL_VoI != NA}).
}
}
\description{
Simulates from (out-of-sample) predictive density for Bayesian VARs estimated
via \code{\link[=bvar]{bvar()}} and computes log predictive likelhoods if ex-post
observed data is supplied.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Split data in train and test
train <- data[1:(nrow(data)-4),]
test <- data[-c(1:(nrow(data)-4)),]

# Estimate model using train data only
mod <- bvar(train, quiet = TRUE)

# Simulate from 1-step to 4-steps ahead posterior predictive and compute
# log-predictive-likelihoods
predictions <- predict(mod, ahead = 1:4, LPL = TRUE, Y_obs = test)

# Summary
summary(predictions)

# Visualize via fan-charts
plot(predictions)

\donttest{
# In order to evaluate the joint predictive density of a subset of the
# variables (variables of interest), consider specifying 'LPL_VoI':
predictions <- predict(mod, ahead = 1:4, LPL = TRUE, Y_obs = test, LPL_VoI = c("GDPC1","FEDFUNDS"))
predictions$LPL_VoI
}
}
\seealso{
\code{\link[=stable_bvar]{stable_bvar()}}, \code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}}, \code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}}.
}
