% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{aic}
\alias{aic}
\title{Computes posterior sample of the pointwise AIC method from a varstan object}
\usage{
aic(x)
}
\arguments{
\item{x}{A varstan object of the time series fitted model.}
}
\value{
A numeric array  of size R, containing the posterior samples of the AICc
for a varstan object, where R is the number of iterations. If multiple chains are
fitted, then the array is of length M*R, where M is the number of chains
}
\description{
Convenience function for computing the pointwise Akaike Information Criteria
method from a varstan object.
}
\examples{
\donttest{
 library(astsa)
 model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(model,chains = 1)

 aic1 <- aic(fit1)
 mean(aic1)
}

}
\author{
Asael Alonzo Matamoros
}
