% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{plot}
\alias{plot}
\alias{plot,bayesGAMfit,missing-method}
\alias{plot,predictPlotObject,missing-method}
\alias{plot,posteriorPredictObject,missing-method}
\title{Additional plotting for MCMC visualization and diagnostics.}
\usage{
\S4method{plot}{bayesGAMfit,missing}(x, y, applylink = TRUE, ...)

\S4method{plot}{predictPlotObject,missing}(x, y, ...)

\S4method{plot}{posteriorPredictObject,missing}(x, y, ...)
}
\arguments{
\item{x}{an object of class \code{hmclearn}, usually a result of a call to \code{mh} or \code{hmc}}

\item{y}{unused}

\item{applylink}{logical to indicate whether the inverse link function should be applied to the plots}

\item{...}{optional additional arguments to pass to the \code{ggplot2}}
}
\value{
A list of \emph{univariate} and \emph{bivariate} plots generated by plot functions based on \code{ggplot2}
}
\description{
Marginal response smooth plot functions for parametric and nonparametric associations.
}
\examples{
f <- bayesGAM(weight ~ np(height), data = women, 
              family = gaussian, iter=500, chains = 1)
plot(f)

}
\references{
H. Wickham. \emph{ggplot2: Elegant Graphics for Data Analysis}. Springer-Verlag New York, 2016.
}
\seealso{
\code{\link{mcmc_plots}}
}
