% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JobCollection.R
\name{makeJobCollection}
\alias{makeJobCollection}
\alias{JobCollection}
\title{JobCollection Constructor}
\usage{
makeJobCollection(ids = NULL, resources = list(),
  reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.
Invalid ids are ignored.}

\item{resources}{[\code{list}]\cr
Named list of resources. Default is \code{list()}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{JobCollection}].
}
\description{
\code{makeJobCollection} takes multiple job ids and creates an object of class \dQuote{JobCollection} which holds all
necessary information for the calculation with \code{\link{doJobCollection}}. It is implemented as an environment
with the following variables:
\describe{
 \item{file.dir}{\code{file.dir} of the \link{Registry}.}
 \item{work.dir:}{\code{work.dir} of the \link{Registry}.}
 \item{job.hash}{Unique identifier of the job. Used to create names on the file system.}
 \item{jobs}{\code{\link[data.table]{data.table}} holding individual job information. See examples.}
 \item{log.file}{Location of the designated log file for this job.}
 \item{resources:}{Named list of of specified computational resources.}
 \item{uri}{Location of the job description file (saved with \code{link[base]{saveRDS}} on the file system.}
 \item{seed}{\code{integer(1)} Seed of the \link{Registry}.}
 \item{packages}{\code{character} with required packages to load via \code{\link[base]{require}}.}
 \item{namespaces}{code{character} with required packages to load via \code{\link[base]{requireNamespace}}.}
 \item{source}{\code{character} with list of files to source before execution.}
 \item{load}{\code{character} with list of files to load before execution.}
 \item{array.var}{\code{character(1)} of the array environment variable specified by the cluster functions.}
 \item{array.jobs}{\code{logical(1)} signaling if jobs were submitted using \code{chunks.as.arrayjobs}.}
}
If your \link{ClusterFunctions} uses a template, \code{\link[brew]{brew}} will be executed in the environment of such
a collection. Thus all variables available inside the job can be used in the template.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE, packages = "methods")
batchMap(identity, 1:5, reg = tmp)

# resources are usually set in submitJobs()
jc = makeJobCollection(1:3, resources = list(foo = "bar"), reg = tmp)
ls(jc)
jc$resources
}
\seealso{
Other JobCollection: \code{\link{doJobCollection}}
}
