% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendline_summary.R
\name{trendline_summary}
\alias{trendline_summary}
\title{Summarized Results of Each Regression Model}
\usage{
trendline_summary(x, y, model = "line2P", Pvalue.corrected = TRUE,
  summary = TRUE, eDigit = 5)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the plot. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{Pvalue.corrected}{if P-value corrected or not, the vlaue is one of c("TRUE", "FALSE").}

\item{summary}{summarizing the model fits. Default is TRUE.}

\item{eDigit}{the numbers of digits for summarized results. Default is 5.}
}
\value{
R^2, indicates the R-Squared value of each regression model.

p, indicates the p-value of each regression model.

N, indicates the sample size.

AIC or BIC, indicate the Akaike's Information Criterion or Bayesian Information Criterion for fitted model. Click \code{\link[stats]{AIC}} for details. The smaller the AIC or BIC, the better the model.

RSS, indicate the value of "Residual Sum of Squares".
}
\description{
Summarizing the results of each regression model which built in the 'trendline()' function. The function includes the following models in the latest version:
"line2P" (formula as: y=a*x+b), "line3P" (y=a*x^2+b*x+c), "log2P" (y=a*ln(x)+b), "exp2P" (y=a*exp(b*x)),"exp3P" (y=a*exp(b*x)+c), "power2P" (y=a*x^b), and "power3P" (y=a*x^b+c).
}
\details{
The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, \cr while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).\cr\cr The argument 'Pvalue.corrected' is workful for non-linear regression only.\cr\cr If "Pvalue.corrected = TRUE", the P-vlaue is calculated by using "Residual Sum of Squares" and "Corrected Total Sum of Squares (i.e. sum((y-mean(y))^2))".\cr If "Pvalue.corrected = TRUE", the P-vlaue is calculated by using "Residual Sum of Squares" and "Uncorrected Total Sum of Squares (i.e. sum(y^2))".
}
\examples{
library(basicTrendline)
x1<-1:5
x2<- -2:2
x3<- c(101,105,140,200,660)
x4<- -5:-1
x5<- c(1,30,90,180,360)

y1<-c(2,14,18,19,20)        # increasing convex trend
y2<- c(-2,-14,-18,-19,-20)  # decreasing concave trend
y3<-c(2,4,16,38,89)         # increasing concave trend
y4<-c(-2,-4,-16,-38,-89)    # decreasing convex trend
y5<- c(600002,600014,600018,600019,600020) # high y values with low range.

trendline_summary(x1,y1,model="line2P",summary=TRUE,eDigit=10)
trendline_summary(x2,y2,model="line3P",summary=FALSE)
trendline_summary(x3,y3,model="log2P")
trendline_summary(x4,y4,model="exp3P")
trendline_summary(x5,y5,model="power3P")

}
\seealso{
\code{\link{trendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
\author{
Weiping Mei, Guangchuang Yu
}
