% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-bso.R
\encoding{UTF-8}
\name{model.bso.customize}
\alias{model.bso.customize}
\title{Customize BSO}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{dd_onset_threshold}{Degree days that are required before the individuals
start regeneration feeding in \code{slot_dia} of the maturation stage. When the
regeneration feeding has finished, the onset is triggered.}

\item{slot_dia}{Maturation feeding slot where the individuals start regeneration feeding after
diapause.}

\item{k}{Factor for the calculation of the phloem temperature.}

\item{alpha, tlo, tup}{Parameters used to calculate the transition probabilities
for each stage (except preflight) in the following order: development, maturation feeding,
reproduction.}

\item{tfly_min, tfly_max, pfly_max, beta}{Parameters used to calculate the
transition probabilities for the preflight stage.}

\item{num_slots}{Named vector that defines the number of slots for each stage.
The development stage is subdivided into the stages \code{egg}, \code{larva} and \code{pupa}.}

\item{psis}{Probability that a sister brood will be established.}

\item{slot_sis}{Maturation feeding slot where the individuals start regeneration feeding before
they establish a sister brood.}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{diapause_first}{The day of year when the diapause could start at the
earliest.}

\item{diapause_last}{The day of year when the diapause could start at the
latest.}

\item{tdia_min}{The diapause will be initiated when the average daily
temperature falls below that value.}
}
\description{
This page describes the parameters
that can be used to customize BSO. The model was developed by
\insertCite{Jakoby2019;textual}{barrks}. Look \link[=model.bso.customize]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for BSO and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
model("bso",

      # ==== onset ====

      dd_onset_start_date = '01-01',
      dd_onset_base = 5.124198,
      dd_onset_threshold = 100,
      slot_dia = 6,

      # ==== onset + development ====

      k = 2.853738e-02,
      alpha = c(2.549060e-05, 0.0000789, 1.009450e-05),
      tlo = c(-1.297644e+01, 4.760089e+00, -4.424628e+00),
      tup = c(3.600070e+01, 4.002483e+01, 3.999390e+01),
      tfly_min = 16.1064,
      tfly_max = 31.2901,
      pfly_max = 9.863263e-03,
      beta = 1.363763,

      num_slots = c(
        'reproduction' = 11,
        'egg' = 18,
        'larva' = 45,
        'pupa' = 8,
        'maturation' = 8,
        'preflight' = 1
      ),

      # ==== development ====

      psis = 2.994450e-01,
      slot_sis = 4,

      model_end_date = '12-30',

      # ==== diapause ====

      diapause_first = 210,
      diapause_last = 232,
      tdia_min = 1.645209e+01
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.bso.apply}}

Other model customizations: 
\code{\link{model.chapy.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.phenips_clim.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
