% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology-results.R
\name{get_generations_rst}
\alias{get_generations_rst}
\alias{get_generations_df}
\alias{get_hibernating_generations_rst}
\alias{get_hibernating_generations_df}
\alias{get_generations}
\title{Get generations}
\usage{
get_generations_rst(
  pheno,
  dates = prop_last_date(pheno),
  threshold = 0,
  generations = prop_hatched_generations(pheno),
  categorical = TRUE,
  colors = barrks_colors("raster"),
  labels = barrks_labels("raster")
)

get_generations_df(
  pheno,
  stations = prop_stations(pheno),
  dates = prop_dates(pheno),
  threshold = 0,
  generations = prop_hatched_generations(pheno)
)

get_hibernating_generations_rst(
  pheno,
  categorical = TRUE,
  colors = barrks_colors("raster"),
  labels = barrks_labels("raster")
)

get_hibernating_generations_df(pheno, stations = prop_stations(pheno))
}
\arguments{
\item{pheno}{A  phenology (see \code{\link[=phenology]{phenology()}})}

\item{dates}{Select dates that should be present in the output.}

\item{threshold}{Threshold of the beetle development to account for a generation.}

\item{generations}{Numeric vector that determines which generations should be
included in the result.}

\item{categorical}{Set \code{FALSE} if the SpatRaster that is returned
should be numeric. Otherwise, it will be categorical.}

\item{colors, labels}{Vectors of colors/labels starting from zero generations followed
consecutively by elements for the respective generations (including sister broods).}

\item{stations}{Pass a character vector to choose stations assigned to \code{pheno} by
their names, or pass different stations. See \code{\link[=stations_create]{stations_create()}} for details.}
}
\value{
\itemize{
\item \code{get_generations_rst()}: A multi-layer SpatRaster.
\item \code{get_hibernating_generations_rst()}: A SpatRaster. Only available
if the model's end date has been reached. Otherwise all values will be \code{NA}.
\item \code{get_generations_df()}: A data frame.
\item \code{get_hibernating_generations_df()}: A data frame. Only available if the
model's end date has been reached. Otherwise all values will be \code{NA}.
}
}
\description{
Find out how many generations are present (or have reached a development
threshold).
}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data(), .quiet = TRUE)

# get the generations raster
gens <- get_generations_rst(p)

# plot the generations raster
terra::plot(gens)
}
}
