% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcredibility.R
\name{plotcredibility}
\alias{plotcredibility}
\title{Generic plot function for metadiag object in bamdit}
\usage{
plotcredibility(
  x,
  parametric.smooth = TRUE,
  level = c(0.5, 0.75, 0.95),
  limits.x = c(0, 1),
  limits.y = c(0, 1),
  color.line = "red",
  color.data.points = "blue",
  title = paste("Posterior Credibility Contours (50\%, 75\% and 95\%)"),
  ...
)
}
\arguments{
\item{x}{The object generated by the metadiag function.}

\item{parametric.smooth}{Indicates if the predictive curve is a parametric or non-parametric.}

\item{level}{Credibility levels of the predictive curve. If parametric.smooth = FALSE, then the probability levels are estimated from the nonparametric surface.}

\item{limits.x}{Numeric vector of length 2 specifying the x-axis limits. The default value is c(0, 1).}

\item{limits.y}{Numeric vector of length 2 specifying the x-axis limits. The default value is c(0, 1).}

\item{color.line}{Color of the predictive contour line.}

\item{color.data.points}{Color of the data points.}

\item{title}{Optional parameter for setting a title in the plot.}

\item{...}{\dots}
}
\description{
This function plots the observe data in the ROC (Receiving Operating Characteristics) space with the
posterior credibility contours.
}
\examples{



\dontrun{
library(bamdit)
data("glas")
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t,                # Data frame
                    re = "normal",         # Random effects distribution
                    re.model = "DS",       # Random effects on D and S
                    link = "logit",        # Link function
                    sd.Fisher.rho   = 1.7, # Prior standard deviation of correlation
                    nr.burnin = 1000,      # Iterations for burnin
                    nr.iterations = 10000, # Total iterations
                    nr.chains = 2,         # Number of chains
                    r2jags = TRUE)         # Use r2jags as interface to jags


 plotcredibility(glas.m1,         # Fitted model
      level = c(0.5, 0.75, 0.95), # Credibility levels
      parametric.smooth = TRUE)   # Parametric curve
}
}
\seealso{
\code{\link{metadiag}}.
}
