% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.compute.R
\name{balance.fromSBP}
\alias{balance.fromSBP}
\title{Compute Balances from an SBP Matrix}
\usage{
balance.fromSBP(x, y)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{y}{A serial binary partition matrix with rows as components (D) and
columns as balances (D-1).}
}
\value{
A transformation of samples for each balance in the SBP matrix.
}
\description{
Compute Balances from an SBP Matrix
}
\examples{
library(balance)
data(iris)
x <- iris[,1:4]
sbp <- sbp.fromPBA(x)
balance.fromSBP(x, sbp)

}
\author{
Thom Quinn
}
