% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{RW2_Infant}
\alias{RW2_Infant}
\title{Second-Order Random Walk Prior with 'Infant' Indicator}
\usage{
RW2_Infant(s = 1, sd_slope = 1, con = c("none", "by"))
}
\arguments{
\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{sd_slope}{Standard deviation
for initial slope of random walk. Default is \code{1}.}

\item{con}{Constraints on parameters.
Current choices are \code{"none"} and \code{"by"}.
Default is \code{"none"}. See below for details.}
}
\value{
Object of class \code{"bage_prior_rw2infant"}.
}
\description{
Use a second-order random walk to model variation
over age, with an indicator variable for the first age group.
Designed for use in models of mortality rates.
}
\details{
A second-order random walk prior \code{\link[=RW2]{RW2()}}
works well for smoothing
mortality rates over age, except at age 0, where there
is a sudden jump in rates, reflecting the
special risks of infancy. The \code{RW2_Infant()}
extends the \code{\link[=RW2]{RW2()}} prior by adding an indicator
variable for the first age group.

If \code{RW2_Infant()} is used in an interaction,
the 'along' dimension is always age, implying that
there is a separate random walk along age within each
combination of the 'by' variables.

Argument \code{s} controls the size of innovations in the random walk.
Smaller values for \code{s} tend to give smoother series.

Argument \code{sd} controls the sl size of innovations in the random walk.
Smaller values for \code{s} tend to give smoother series.
}
\section{Mathematical details}{


When \code{RW2_Infant()} is used with a main effect,

\deqn{\beta_1 \sim \text{N}(0, 1)}
\deqn{\beta_2 \sim \text{N}(0, \mathtt{sd\_slope}^2)}
\deqn{\beta_3 \sim \text{N}(2 \beta_2, \tau^2)}
\deqn{\beta_j \sim \text{N}(2 \beta_{j-1} - \beta_{j-2}, \tau^2), \quad j = 3, \cdots, J}

and when it is used with an interaction,

\deqn{\beta_{u,1} \sim \text{N}(0, 1)}
\deqn{\beta_{u,2} \sim \text{N}(0, \mathtt{sd\_slope}^2)}
\deqn{\beta_{u,3} \sim \text{N}(2 \beta_{u,2}, \tau^2)}
\deqn{\beta_{u,v} \sim \text{N}(2 \beta_{u,v-1} - \beta_{u,v-2}, \tau^2), \quad v = 3, \cdots, V}

where
\itemize{
\item \eqn{\pmb{\beta}} is a main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the 'along' variable of the interaction; and
\item \eqn{u} denotes position within the 'by' variable(s) of the interaction.
}

Parameter \eqn{\tau} has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \mathtt{s}^2)}.
}

\section{Constraints}{


With some combinations of terms and priors, the values of
the intercept, main effects, and interactions are
are only weakly identified.
For instance, it may be possible to increase the value of the
intercept and reduce the value of the remaining terms in
the model with no effect on predicted rates and only a tiny
effect on prior probabilities. This weak identifiability is
typically harmless. However, in some applications, such as
when trying to obtain interpretable values
for main effects and interactions, it can be helpful to increase
identifiability through the use of constraints, specified through the
\code{con} argument.

Current options for \code{con} are:
\itemize{
\item \code{"none"} No constraints. The default.
\item \code{"by"} Only used in interaction terms that include 'along' and
'by' dimensions. Within each value of the 'along'
dimension, terms across each 'by' dimension are constrained
to sum to 0.
}
}

\examples{
RW2_Infant()
RW2_Infant(s = 0.1)
}
\seealso{
\itemize{
\item \code{\link[=RW2]{RW2()}} Second-order random walk, without infant indicator
\item \code{\link[=Sp]{Sp()}} Smoothing via splines
\item \code{\link[=SVD]{SVD()}} Smoothing over age via singular value decomposition
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig2_math.html}{Mathematical Details}
vignette
}
}
